<?php $__env->startSection('content'); ?>
    <h3 class="page-title">Appointments </h3>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('working_hour_create')): ?>
    <p>
        <a href="<?php echo e(route('admin.working_hours.create')); ?>" class="btn btn-success"><?php echo app('translator')->getFromJson('quickadmin.qa_add_new'); ?></a>
        
    </p>
    <?php endif; ?>

    <link rel='stylesheet' href='https://cdnjs.cloudflare.com/ajax/libs/fullcalendar/3.1.0/fullcalendar.min.css' />

    <div id='calendar'></div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
    <script src='https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.17.1/moment.min.js'></script>
    <script src='https://cdnjs.cloudflare.com/ajax/libs/fullcalendar/3.1.0/fullcalendar.min.js'></script>
    <script>
        $(document).ready(function() {
            // page is now ready, initialize the calendar...
            $('#calendar').fullCalendar({
                // put your options and callbacks here
                defaultView: 'agendaWeek',
                events : [
                    <?php $__currentLoopData = $working_hours; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hour): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    {
                        title : '<?php echo e($hour->employee->first_name . ' ' . $hour->employee->last_name); ?>',
                        start : '<?php echo e($hour->date . ' ' . $hour->start_time); ?>',
                        end : '<?php echo e($hour->date . ' ' . $hour->finish_time); ?>',
                        url : '<?php echo e(route('admin.working_hours.edit', $hour->id)); ?>'
                    },
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                ]
            })
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>