<?php $request = app('Illuminate\Http\Request'); ?>
<div class="page-sidebar-wrapper">
    <div class="page-sidebar navbar-collapse collapse">
        <ul class="page-sidebar-menu"
            data-keep-expanded="false"
            data-auto-scroll="true"
            data-slide-speed="200">
            
            <li class="<?php echo e($request->segment(1) == 'home' ? 'active' : ''); ?>">
                <a href="<?php echo e(url('/')); ?>">
                    <i class="fa fa-wrench"></i>
                    <span class="title"><?php echo app('translator')->getFromJson('quickadmin.qa_dashboard'); ?></span>
                </a>
            </li>
            
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('client_access')): ?>
            <li class="<?php echo e($request->segment(2) == 'clients' ? 'active' : ''); ?>">
                <a href="<?php echo e(route('admin.clients.index')); ?>">
                    <i class="fa fa-user"></i>
                    <span class="title"><?php echo app('translator')->getFromJson('quickadmin.clients.title'); ?></span>
                </a>
            </li>
            <?php endif; ?>
            
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('employee_access')): ?>
            <li class="<?php echo e($request->segment(2) == 'employees' ? 'active' : ''); ?>">
                <a href="<?php echo e(route('admin.employees.index')); ?>">
                    <i class="fa fa-suitcase"></i>
                    <span class="title"><?php echo app('translator')->getFromJson('quickadmin.employees.title'); ?></span>
                </a>
            </li>
            <?php endif; ?>
            
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('working_hour_access')): ?>
            <li class="<?php echo e($request->segment(2) == 'working_hours' ? 'active' : ''); ?>">
                <a href="<?php echo e(route('admin.working_hours.index')); ?>">
                    <i class="fa fa-hourglass"></i>
                    <span class="title"><?php echo app('translator')->getFromJson('quickadmin.appointments.title'); ?></span>
                </a>
            </li>
			
			<li class="<?php echo e($request->segment(2) == 'appointments' ? 'active' : ''); ?>">
                <a href="<?php echo e(route('admin.appointments.index')); ?>">
                    <i class="fa fa-hourglass"></i>
                    <span class="title"><?php echo app('translator')->getFromJson('quickadmin.appointments.title'); ?> Import</span>
                </a>
            </li>
			
			
			
			<li class="<?php echo e($request->segment(2) == 'taskmanager' ? 'active' : ''); ?>">
                <a href="<?php echo e(route('admin.taskmanager.index')); ?>">
                    <i class="fa fa-hourglass"></i>
                    <span class="title">Task Manager</span>
                </a>
            </li>
			
			<li class="<?php echo e($request->segment(2) == 'task_import' ? 'active' : ''); ?>">
                <a href="<?php echo e(route('admin.task_import.index')); ?>">
                    <i class="fa fa-hourglass"></i>
                    <span class="title">Task Import</span>
                </a>
            </li>
			
			
            <?php endif; ?>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('service_access')): ?>
            <li class="<?php echo e($request->segment(2) == 'services' ? 'active' : ''); ?>">
                <a href="<?php echo e(route('admin.services.index')); ?>">
                    <i class="fa fa-hourglass"></i>
                    <span class="title"><?php echo app('translator')->getFromJson('quickadmin.services.title'); ?></span>
                </a>
            </li>
            <?php endif; ?>			
            
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('appointment_access')): ?>
           <!-- <li class="<?php echo e($request->segment(2) == 'appointments' ? 'active' : ''); ?>">
                <a href="<?php echo e(route('admin.appointments.index')); ?>">
                    <i class="fa fa-calendar"></i>
                    <span class="title"><?php echo app('translator')->getFromJson('quickadmin.appointments.title'); ?></span>
                </a>
            </li>-->
            <?php endif; ?>


            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('user_management_access')): ?>
                <li class="">
                    <a href="#">
                        <i class="fa fa-users"></i>
                        <span class="title"><?php echo app('translator')->getFromJson('quickadmin.user-management.title'); ?></span>
                        <span class="fa arrow"></span>
                    </a>
                    <ul class="sub-menu">

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('role_access')): ?>
                            <li class="<?php echo e($request->segment(2) == 'roles' ? 'active active-sub' : ''); ?>">
                                <a href="<?php echo e(route('admin.roles.index')); ?>">
                                    <i class="fa fa-briefcase"></i>
                                    <span class="title">
                                <?php echo app('translator')->getFromJson('quickadmin.roles.title'); ?>
                            </span>
                                </a>
                            </li>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('user_access')): ?>
                            <li class="<?php echo e($request->segment(2) == 'users' ? 'active active-sub' : ''); ?>">
                                <a href="<?php echo e(route('admin.users.index')); ?>">
                                    <i class="fa fa-user"></i>
                                    <span class="title">
                                <?php echo app('translator')->getFromJson('quickadmin.users.title'); ?>
                            </span>
                                </a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </li>
            <?php endif; ?>

            <li class="<?php echo e($request->segment(1) == 'change_password' ? 'active' : ''); ?>">
                <a href="<?php echo e(route('auth.change_password')); ?>">
                    <i class="fa fa-key"></i>
                    <span class="title">Change password</span>
                </a>
            </li>

            <li>
                <a href="#logout" onclick="$('#logout').submit();">
                    <i class="fa fa-arrow-left"></i>
                    <span class="title"><?php echo app('translator')->getFromJson('quickadmin.qa_logout'); ?></span>
                </a>
            </li>
        </ul>
    </div>
</div>
<?php echo Form::open(['route' => 'auth.logout', 'style' => 'display:none;', 'id' => 'logout']); ?>

<button type="submit"><?php echo app('translator')->getFromJson('quickadmin.logout'); ?></button>
<?php echo Form::close(); ?>

