<?php

namespace App\Http\Controllers\Admin;

use App\Taskmanager;
use App\Appointment;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;
use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\StoreTaskmanagerRequest;
use App\Http\Requests\Admin\UpdateTaskmanagerRequest;

use Excel;

class TaskmanagerController extends Controller
{
    /**
     * Display a listing of Appointment.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        if (! Gate::allows('appointment_access')) {
            return abort(401);
        }

        $taskmanager = Taskmanager::all();

        return view('admin.taskmanager.index', compact('taskmanager'));
    }

    /**
     * Show the form for creating new Appointment.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        if (! Gate::allows('appointment_create')) {
            return abort(401);
        }
		
		
		
		
        $relations = [
		    'owner' => \App\Owner::get(),
		    'company' => \App\Company::get(),
		    'segments' => \App\Segment::get(),
            'status' => \App\Status::get(),
            'employees' => \App\Employee::get(),
			'meeting' => \App\Meeting::get(),
        ];
    
        //return view('admin.taskmanager.create', compact('segments') +$relations);
		
		return view('admin.taskmanager.create', $relations);
		
		
    }

    /**
     * Store a newly created Appointment in storage.
     *
     * @param  \App\Http\Requests\StoreAppointmentsRequest  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreTaskmanagerRequest $request)
    {
        if (! Gate::allows('appointment_create')) {
            return abort(401);
        }
		
		
		/*
		$employee = \App\Employee::find($request->employee_id);
		$working_hours = \App\WorkingHour::where('employee_id', $request->employee_id)->whereDay('date', '=', date("d", strtotime($request->date)))->whereTime('start_time', '<=', date("H:i", strtotime("".$request->starting_hour.":".$request->starting_minute.":00")))->whereTime('finish_time', '>=', date("H:i", strtotime("".$request->finish_hour.":".$request->finish_minute.":00")))->get();
		if(!$employee->provides_service($request->service_id)) return redirect()->back()->withErrors("This employee doesn't provide your selected service")->withInput();
        if($working_hours->isEmpty()) return redirect()->back()->withErrors("This employee isn't working at your selected time")->withInput();
		*/
		
		$taskmanager = new Taskmanager;
		$taskmanager->company_id = $request->company_id;
		$taskmanager->item = $request->item;
		$taskmanager->segment_id = $request->segment_id;
		
		$taskmanager->owner_id = $request->owner_id;
		$taskmanager->employee_id = $request->employee_id;
		$taskmanager->type_of_meeting = $request->type_of_meeting;
		
		$taskmanager->meeting_date = $request->meeting_date;
		$taskmanager->deadline = $request->deadline;
		$taskmanager->review_date = $request->review_date;
		
		$taskmanager->progress_status = $request->progress_status;
		$taskmanager->remarks = $request->remarks;
		$taskmanager->reminder = $request->reminder;
		
		$taskmanager->email = $request->email;
		$taskmanager->email_cc = $request->email_cc;
		
		
		
		$taskmanager->save();



        return redirect()->route('admin.taskmanager.index');
    }


    /**
     * Show the form for editing Appointment.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        if (! Gate::allows('appointment_edit')) {
            return abort(401);
        }
      /*  $relations = [
            'clients' => \App\Client::get()->pluck('first_name', 'id')->prepend('Please select', ''),
            'employees' => \App\Employee::get()->pluck('first_name', 'id')->prepend('Please select', ''),
        ];*/
		
		        $relations = [
		    'owner' => \App\Owner::get()->pluck('owner_name','owner_name')->prepend('Please select', ''),
		    'company' => \App\Company::get()->pluck('company_name', 'company_name')->prepend('Please select', ''),
		    'segments' => \App\Segment::get()->pluck('segment_name', 'segment_name')->prepend('Please select', ''),
            'status' => \App\Status::get()->pluck('name', 'name')->prepend('Please select', ''),
            'employees' => \App\Employee::get()->pluck('first_name', 'first_name')->prepend('Please select', ''),
			'meeting' => \App\Meeting::get()->pluck('name', 'name')->prepend('Please select', ''),
        ];
		
		

        $taskmanager = Taskmanager::findOrFail($id);

        return view('admin.taskmanager.edit', compact('taskmanager') + $relations);
    }

    /**
     * Update Appointment in storage.
     *
     * @param  \App\Http\Requests\UpdateAppointmentsRequest  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateTaskmanagerRequest $request, $id)
    {
        if (! Gate::allows('appointment_edit')) {
            return abort(401);
        }
		//$taskmanager = new Taskmanager;
        $taskmanager = Taskmanager::findOrFail($id);
		
        $taskmanager->update($request->all());



        return redirect()->route('admin.taskmanager.index');
    }
	
	
	
	
		public function excel()
	{
		
		$file = $request->file('contacts_csv');
                $imported_data = Excel::load($file->getRealPath())
                                ->noHeading()
                                ->skipRows(1)
                                ->get()
                                ->toArray();
		Excel::load($file->getRealPath(), function($reader) {

		//DB::table('excel_sheet')->where()->delete();

	
		DB::table('excel_sheet')->delete();
		
		
		$reader->each(function($sheet) {

        $sheet_title = $sheet->getTitle();
   
        foreach($sheet as $row)
		 {
		
		
		 $sheet_value = json_encode($row);
		 print_r($sheet_value);
		 echo "<br>";
		 
		/*    $purchase = DB::table('excel_sheet')->insert(
                                    ['sheet_name' => $sheet_title,
                                    'sheet_data' => $sheet_value]
                                  );
								  
					  */
		


        }

        });



		});


		// return view('contact.ecel')
          //  ->with(compact('data'));
	}

	
		public function task_import()
	{
		
		if (! Gate::allows('appointment_access')) {
            return abort(401);
        }

        $appointments = Appointment::all();

        return view('admin.appointments.task', compact('appointments'));
	}
	
	
   public function show($id)
    {
		echo "ddddddddddddd";
	}
	
    /**
     * Display Appointment.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
   /* public function show($id)
    {
        if (! Gate::allows('appointment_view')) {
            return abort(401);
        }
        $relations = [
            'clients' => \App\Client::get()->pluck('first_name', 'id')->prepend('Please select', ''),
            'employees' => \App\Employee::get()->pluck('first_name', 'id')->prepend('Please select', ''),
        ];

        $appointment = Appointment::findOrFail($id);

        return view('admin.appointments.show', compact('appointment') + $relations);
    }
    */

    /**
     * Remove Appointment from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
	 
	 /*
    public function destroy($id)
    {
        if (! Gate::allows('appointment_delete')) {
            return abort(401);
        }
        $appointment = Appointment::findOrFail($id);
        $appointment->delete();

        return redirect()->route('admin.appointments.index');
    }
	*/

    /**
     * Delete all selected Appointment at once.
     *
     * @param Request $request
     */
  
/*
  public function massDestroy(Request $request)
    {
        if (! Gate::allows('appointment_delete')) {
            return abort(401);
        }
        if ($request->input('ids')) {
            $entries = Appointment::whereIn('id', $request->input('ids'))->get();

            foreach ($entries as $entry) {
                $entry->delete();
            }
        }
    }
	*/


}
